/************************************************************************
 * \file: adit_typedef.h
 *
 * \version: $Id: adit_typedef.h,v 1.2 2010/05/27 08:33:01 cspetzler Exp $
 *
 * This header file declares the basic types that are to be used for programming
 * of the ADIT platform.
 *
 * \component: global definition file
 *
 * \author: T.Rodenbach <trodenbach@de.adit-jv.com>
 *
 * \copyright: (c) 2003 - 2004 ADIT Corporation
 *
 ***********************************************************************/

#ifndef ADIT_TYPEDEF_H
#define ADIT_TYPEDEF_H

#if defined(BUILDENV_NUCLEUS)
#   include "adit_typedef_nucleus.h"
#elif defined(BUILDENV_ESOL)
#   include "adit_typedef_tkernel.h"
#elif defined(BUILDENV_PMC)
#   include "adit_typedef_tkernel.h"
#elif defined(BUILDENV_TSIM)
#   include "adit_typedef_tkernel.h"
#elif defined(BUILDENV_LINUX)
#   include "adit_typedef_linux.h"
#else
#   error "No known define for buildenv set (BUILDENV_ESOL, BUILDENV_NUCLEUS, \
           BUILDENV_LINUX, BUILDENV_TSIM or BUILDENV_PMC)"
#endif /* BUILDENV_* */

#endif /* ADIT_TYPEDEF_H */
